IF  EXISTS (SELECT * FROM sys.objects WHERE OBJECT_ID = OBJECT_ID(N'[dbo].[VX_sp_ExtractGroupRecordForIntweb]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_ExtractGroupRecordForIntweb]
GO


CREATE PROCEDURE  [dbo].[VX_sp_ExtractGroupRecordForIntweb]
 @UserId    INT                 = 0,
 @ProjectId INT                 = 0,
 @GroupNumber INT               = 0 -- from 0 to 9

AS

SET NOCOUNT ON;
DECLARE @lockResult INT;
DECLARE @ErrorMessage NVARCHAR(4000);
DECLARE @ErrorSeverity INT;
DECLARE @ErrorState INT;
DECLARE @TraceId BIGINT;
DECLARE @ExpiredRecordTime DATETIME;
DECLARE @MaxCbDate DATETIME = '9999-12-31T00:00:00Z'

SET @TraceId = null;
SET @ExpiredRecordTime = DATEADD(MINUTE, -5, GETUTCDATE());

EXEC @lockResult = sp_getapplock 'sp_new', 'Exclusive', 'Session', 600000;
IF ( (@lockResult = 0) or (@lockResult = 1)) --- SUCCESS
BEGIN
    BEGIN TRY
        SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
        EXEC sp_UpdateStrataState 0, @UserId;

        -- Clear all Expired Record
        DELETE FROM dbo.BufferNew WHERE NewDateTime <= @ExpiredRecordTime -- this is 5 minutes delay for a record into BufferNew

        CREATE TABLE #ExtractedRecords ( Respondent VARCHAR(10) PRIMARY KEY, ResCall INT, ComputeCB DATETIME, Phone NVARCHAR(100), callbackdate DATETIME, OrderKey INT) 
        BEGIN TRY
            -- Check for available records into dbo.BufferNew table
            INSERT INTO #ExtractedRecords
                SELECT TOP 1 n.Respondent, n.ResCall, 
                                        COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                                        n.Phone,
                                        n.callbackdate,
                                        n.OrderKey 
                FROM dbo.BufferNew n WITH (TABLOCKX)
                WHERE intgroup = @GroupNumber AND 
                      n.rescall=0
                ORDER BY n.OrderKey;

            IF @@ROWCOUNT = 0
            BEGIN
                -- No record available, we will trigger the FillCaseBuffer to fill dbo.BufferNew
                EXEC VX_sp_FillCaseBuffer 100, 0, 255, 1, @GroupNumber , null, null, @TraceId OUT, 0, '', 0;

                -- Requery dbo.BufferNew
                INSERT INTO #ExtractedRecords
                    SELECT TOP 1 n.Respondent, n.ResCall, 
                                            COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                                            n.Phone,
                                            n.callbackdate,
                                            n.OrderKey 
                    FROM dbo.BufferNew n WITH (TABLOCKX)
                    WHERE intgroup = @GroupNumber AND 
                          n.rescall=0
                    ORDER BY n.OrderKey;
            END

            -------- The Following 2 Queries are directly taken from sp_UpDateForNew
            --------     The Store Procedure was possible for only a record at the time
            --------     We change it to execute the update with a recordset instead of a single Key
            -- Update the records Extracted into Respondent table so that it can't be extracted until it is called or recycled
            UPDATE respondent
            SET    rescall = 1,
                   respreviouscalldate = rescallbackdate,
                   rescallbackdate = 0,
                   projectid = @projectId,
                   modifiedby = @userId,
                   modified = GETUTCDATE()
            WHERE  resrespondent IN (SELECT #ExtractedRecords.Respondent FROM #ExtractedRecords)

            -- Flag use records of the dbo.buffernew so it can't be use a second time
            UPDATE dbo.buffernew
            SET    rescall = 1
            WHERE  respondent IN (SELECT #ExtractedRecords.Respondent FROM #ExtractedRecords)
                   AND intgroup = @GroupNumber

            --- update quota Online and Unused
            UPDATE quota SET qtOnline= qtOnline + valueonline, qtunused = qtunused - valueUnused
            FROM quota INNER JOIN
                (SELECT strquotaid, SUM(stratum.IncrementValue) valueOnline , SUM(CASE WHEN callbackdate <= 0 THEN stratum.IncrementValue ELSE 0 END) valueUnused
                 FROM #ExtractedRecords INNER JOIN stratum WITH(NOLOCK) ON strrespondent = respondent
                 GROUP BY strquotaid
                ) UsedStratum ON quota.qtquotaid = UsedStratum.strquotaid
            WHERE qtstratum >0;
            -- we decrement the unused for the global quotas
            UPDATE quota SET qtunused = qtunused - (SELECT COUNT(*) FROM #ExtractedRecords WHERE callbackdate <=0)
            WHERE qtstratum = 0
    
            --   INTWEB doesnt do this, records are flag (rescall=1)
            --   DELETE FROM dbo.BufferNew WHERE Respondent in (SELECT respondent FROM #ExtractedRecords);
            SET NOCOUNT OFF;

            -- this is the return select with all the records
            SELECT #ExtractedRecords.* FROM #ExtractedRecords
                ORDER BY OrderKey;

        END TRY
        BEGIN CATCH
            SELECT 
			    @ErrorMessage = ERROR_MESSAGE() + ':' + isnull(ERROR_PROCEDURE(), '??') + '(' + convert(NVARCHAR(20), ERROR_LINE()) + ')',
                @ErrorSeverity = ERROR_SEVERITY(),
                @ErrorState = ERROR_STATE();
            DROP TABLE #ExtractedRecords;
            RAISERROR (@ErrorMessage, -- Message text.
                       @ErrorSeverity, -- Severity.
                       @ErrorState -- State.
                      );
        END CATCH
        -- We remove temporary table from the excution for the workflow of the next time we call this
        DROP TABLE #ExtractedRecords;
    END TRY
    BEGIN CATCH
        SELECT 
		    @ErrorMessage = ERROR_MESSAGE() + ':' + isnull(ERROR_PROCEDURE(), '??') + '(' + convert(NVARCHAR(20), ERROR_LINE()) + ')',
            @ErrorSeverity = ERROR_SEVERITY(),
            @ErrorState = ERROR_STATE();
        EXEC @lockResult = sp_releaseapplock 'sp_new', 'Session';
        RAISERROR (@ErrorMessage, -- Message text.
                   @ErrorSeverity, -- Severity.
                   @ErrorState -- State.
                  );
        RETURN;
    END CATCH
    
    EXEC @lockResult = sp_releaseapplock 'sp_new', 'Session';
END
ELSE
BEGIN
    -- raise @lockResult and message about error on Lock sp_new
    RAISERROR ('Error in get application lock', -- Message text.
               -1, -- Severity.
               0 -- State.
              );
 RETURN;
END